// --------------------------------------------------------------------
// Copyright (c) 2005 by Terasic Technologies Inc. 
// --------------------------------------------------------------------
//
// Permission:
//
//   Terasic grants permission to use and modify this code for use
//   in synthesis for all Terasic Development Boards and Altera Development 
//   Kits made by Terasic.  Other use of this code, including the selling 
//   ,duplication, or modification of any portion is strictly prohibited.
//
// Disclaimer:
//
//   This VHDL/Verilog or C/C++ source code is intended as a design reference
//   which illustrates how these types of functions can be implemented.
//   It is the user's responsibility to verify their design for
//   consistency and functionality through the use of formal
//   verification methods.  Terasic provides no warranty regarding the use 
//   or functionality of this code.
//
// --------------------------------------------------------------------
//           
//                     Terasic Technologies Inc
//                     356 Fu-Shin E. Rd Sec. 1. JhuBei City,
//                     HsinChu County, Taiwan
//                     302
//
//                     web: http://www.terasic.com/
//                     email: support@terasic.com
//
// --------------------------------------------------------------------
//
// Major Functions:	DE2 LTM Module Display of Photo 
//
// --------------------------------------------------------------------
//
// Revision History :
// --------------------------------------------------------------------
//   Ver  :| Author            		:| Mod. Date :| Changes Made:
//   V1.0 :| Joe Yang,Johnny Fan	:| 07/03/30  :| Initial Revision
// --------------------------------------------------------------------

module DE2_LTM_Ephoto
	(
		////////////////////	Clock Input	 	////////////////////	 
		CLOCK_27,						//	27 MHz
		CLOCK_50,						//	50 MHz
		EXT_CLOCK,						//	External Clock
		////////////////////	Push Button		////////////////////
		KEY,							//	Pushbutton[3:0]
		////////////////////	DPDT Switch		////////////////////
		SW,								//	Toggle Switch[17:0]
		////////////////////	7-SEG Dispaly	////////////////////
		HEX0,							//	Seven Segment Digit 0
		HEX1,							//	Seven Segment Digit 1
		HEX2,							//	Seven Segment Digit 2
		HEX3,							//	Seven Segment Digit 3
		HEX4,							//	Seven Segment Digit 4
		HEX5,							//	Seven Segment Digit 5
		HEX6,							//	Seven Segment Digit 6
		HEX7,							//	Seven Segment Digit 7


		/////////////////////	SDRAM Interface		////////////////
		DRAM_DQ,						//	SDRAM Data bus 16 Bits
		DRAM_ADDR,						//	SDRAM Address bus 12 Bits
		DRAM_LDQM,						//	SDRAM Low-byte Data Mask 
		DRAM_UDQM,						//	SDRAM High-byte Data Mask
		DRAM_WE_N,						//	SDRAM Write Enable
		DRAM_CAS_N,						//	SDRAM Column Address Strobe
		DRAM_RAS_N,						//	SDRAM Row Address Strobe
		DRAM_CS_N,						//	SDRAM Chip Select
		DRAM_BA_0,						//	SDRAM Bank Address 0
		DRAM_BA_1,						//	SDRAM Bank Address 0
		DRAM_CLK,						//	SDRAM Clock
		DRAM_CKE,						//	SDRAM Clock Enable
		////////////////////	Flash Interface		////////////////
		FL_DQ,							//	FLASH Data bus 8 Bits
		FL_ADDR,						//	FLASH Address bus 22 Bits
		FL_WE_N,						//	FLASH Write Enable
		FL_RST_N,						//	FLASH Reset
		FL_OE_N,						//	FLASH Output Enable
		FL_CE_N,						//	FLASH Chip Enable

		GPIO_0,
		
				////////////////////	SRAM Interface		////////////////
		SRAM_DQ,						//	SRAM Data bus 16 Bits
		SRAM_ADDR,						//	SRAM Address bus 18 Bits
		SRAM_UB_N,						//	SRAM High-byte Data Mask 
		SRAM_LB_N,						//	SRAM Low-byte Data Mask 
		SRAM_WE_N,						//	SRAM Write Enable
		SRAM_CE_N,						//	SRAM Chip Enable
		SRAM_OE_N,						//	SRAM Output Enable
		
		
	pio_racket_left,
    pio_racket_right,
   pio_pingpong,
   pio_hex,

   pio_sw,
   pio_key
		

	
	);
//===========================================================================
// PORT declarations
//===========================================================================
////////////////////////	Clock Input	 	////////////////////////
input			CLOCK_27;				//	27 MHz
input			CLOCK_50;				//	50 MHz
input			EXT_CLOCK;				//	External Clock
////////////////////////	Push Button		////////////////////////
input	[3:0]	KEY;					//	Pushbutton[3:0]
////////////////////////	DPDT Switch		////////////////////////
input	[17:0]	SW;						//	Toggle Switch[17:0]
////////////////////////	7-SEG Dispaly	////////////////////////
output	[6:0]	HEX0;					//	Seven Segment Digit 0
output	[6:0]	HEX1;					//	Seven Segment Digit 1
output	[6:0]	HEX2;					//	Seven Segment Digit 2
output	[6:0]	HEX3;					//	Seven Segment Digit 3
output	[6:0]	HEX4;					//	Seven Segment Digit 4
output	[6:0]	HEX5;					//	Seven Segment Digit 5
output	[6:0]	HEX6;					//	Seven Segment Digit 6
output	[6:0]	HEX7;					//	Seven Segment Digit 7

///////////////////////		SDRAM Interface	////////////////////////
inout	[15:0]	DRAM_DQ;				//	SDRAM Data bus 16 Bits
output	[11:0]	DRAM_ADDR;				//	SDRAM Address bus 12 Bits
output			DRAM_LDQM;				//	SDRAM Low-byte Data Mask 
output			DRAM_UDQM;				//	SDRAM High-byte Data Mask
output			DRAM_WE_N;				//	SDRAM Write Enable
output			DRAM_CAS_N;				//	SDRAM Column Address Strobe
output			DRAM_RAS_N;				//	SDRAM Row Address Strobe
output			DRAM_CS_N;				//	SDRAM Chip Select
output			DRAM_BA_0;				//	SDRAM Bank Address 0
output			DRAM_BA_1;				//	SDRAM Bank Address 0
output			DRAM_CLK;				//	SDRAM Clock
output			DRAM_CKE;				//	SDRAM Clock Enable
////////////////////////	Flash Interface	////////////////////////
inout	[7:0]	FL_DQ;					//	FLASH Data bus 8 Bits
output	[21:0]	FL_ADDR;				//	FLASH Address bus 22 Bits
output			FL_WE_N;				//	FLASH Write Enable
output			FL_RST_N;				//	FLASH Reset
output			FL_OE_N;				//	FLASH Output Enable
output			FL_CE_N;				//	FLASH Chip Enable


////////////////////////	GPIO	////////////////////////////////

inout	[35:0]	GPIO_0;					//	GPIO Connection 0

////////////////////////	SRAM Interface	////////////////////////
inout	[15:0]	SRAM_DQ;				//	SRAM Data bus 16 Bits
output	[17:0]	SRAM_ADDR;				//	SRAM Address bus 18 Bits
output			SRAM_UB_N;				//	SRAM High-byte Data Mask 
output			SRAM_LB_N;				//	SRAM Low-byte Data Mask 
output			SRAM_WE_N;				//	SRAM Write Enable
output			SRAM_CE_N;				//	SRAM Chip Enable
output			SRAM_OE_N;				//	SRAM Output Enable



////////////////////////////
//	All inout port turn to tri-state
assign	DRAM_DQ		=	16'hzzzz;
assign	OTG_DATA	=	16'hzzzz;
assign	LCD_DATA	=	8'hzz;
assign	SD_DAT		=	1'bz;
assign	ENET_DATA	=	16'hzzzz;
assign	AUD_ADCLRCK	=	1'bz;
assign	AUD_DACLRCK	=	1'bz;
assign	AUD_BCLK	=	1'bz;
assign	GPIO_1		=	36'hzzzzzzzzz;
//=============================================================================
// REG/WIRE declarations
//=============================================================================
// Touch panel signal //
wire	[7:0]	ltm_r;		//	LTM Red Data 8 Bits
wire	[7:0]	ltm_g;		//	LTM Green Data 8 Bits
wire	[7:0]	ltm_b;		//	LTM Blue Data 8 Bits
wire			ltm_nclk;	//	LTM Clcok
wire			ltm_hd;		
wire			ltm_vd;		
wire			ltm_den;	
wire 			adc_dclk;
wire 			adc_cs;
wire 			adc_penirq_n;
wire 			adc_busy;
wire 			adc_din;
wire 			adc_dout;
wire 			adc_ltm_sclk;		
wire			ltm_grst;
// LTM Config//
wire			ltm_sclk;		
wire			ltm_sda;		
wire			ltm_scen;
wire 			ltm_3wirebusy_n;

wire	[11:0] 	x_coord;
wire	[11:0] 	y_coord;
wire			new_coord;	
wire	[2:0]	photo_cnt;
// clock
wire 			F_CLK;// flash read clock
reg 	[31:0] 	div;
// sdram to touch panel timing
wire			mRead;
wire	[15:0]	Read_DATA1;
wire	[15:0]	Read_DATA2;	
//  flash to sdram sdram
wire	[7:0]   sRED;// flash to sdram red pixel data		
wire	[7:0]	sGREEN;// flash to sdram green pixel data
wire	[7:0]	sBLUE;// flash to sdram blue pixel data
wire			sdram_write_en; // flash to sdram write control
wire			sdram_write; // sdram write signal
// system reset
wire			DLY0;
wire			DLY1;
wire			DLY2;

//=============================================================================
// Structural coding
//=============================================================================	

//////////////////////////////////////////
assign	adc_penirq_n  =GPIO_0[0];
assign	adc_dout    =GPIO_0[1];
assign	adc_busy    =GPIO_0[2];
assign	GPIO_0[3]	=adc_din;
assign	GPIO_0[4]	=adc_ltm_sclk;
assign	GPIO_0[5]	=ltm_b[3];
assign	GPIO_0[6]	=ltm_b[2];
assign	GPIO_0[7]	=ltm_b[1];
assign	GPIO_0[8]	=ltm_b[0];
assign	GPIO_0[9]	=ltm_nclk;
assign	GPIO_0[10]	=ltm_den;
assign	GPIO_0[11]	=ltm_hd;
assign	GPIO_0[12]	=ltm_vd;
assign	GPIO_0[13]	=ltm_b[4];
assign	GPIO_0[14]	=ltm_b[5];
assign	GPIO_0[15]	=ltm_b[6];
assign	GPIO_0[16]	=ltm_b[7];
assign	GPIO_0[17]	=ltm_g[0];
assign	GPIO_0[18]	=ltm_g[1];
assign	GPIO_0[19]	=ltm_g[2];
assign	GPIO_0[20]	=ltm_g[3];
assign	GPIO_0[21]	=ltm_g[4];
assign	GPIO_0[22]	=ltm_g[5];
assign	GPIO_0[23]	=ltm_g[6];
assign	GPIO_0[24]	=ltm_g[7];
assign	GPIO_0[25]	=ltm_r[0];
assign	GPIO_0[26]	=ltm_r[1];
assign	GPIO_0[27]	=ltm_r[2];
assign	GPIO_0[28]	=ltm_r[3];
assign	GPIO_0[29]	=ltm_r[4];
assign	GPIO_0[30]	=ltm_r[5];
assign	GPIO_0[31]	=ltm_r[6];
assign	GPIO_0[32]	=ltm_r[7];
assign	GPIO_0[33]	=ltm_grst;
assign	GPIO_0[34]	=ltm_scen;
assign	GPIO_0[35]	=ltm_sda;

////////////////////////////////////////
assign ltm_grst		= KEY[0];
assign F_CLK 		= div[3];
assign adc_ltm_sclk	= ( adc_dclk & ltm_3wirebusy_n )  |  ( ~ltm_3wirebusy_n & ltm_sclk );
always @( posedge CLOCK_50 )
	begin
		div <= div+1;
	end	

///////////////////////////////////////////////////////////////
/*********************************************************out*****************************/
output  [31:0]pio_racket_left;
output  [31:0] pio_racket_right;
output [31:0] pio_pingpong;
output  [15:0]  pio_hex;

output [31:0]pio_sw;
output pio_key;




hope   jjj(
              // 1) global signals:
               .clk(CLOCK_50),
               .reset_n(KEY[0]),

              // the_pio_hex
               .out_port_from_the_pio_hex(pio_hex),

              // the_pio_key
               .in_port_to_the_pio_key(pio_key),

              // the_pio_left
               .out_port_from_the_pio_left(pio_racket_left),

              // the_pio_pingpong
               .out_port_from_the_pio_pingpong(pio_pingpong),

              // the_pio_right
               .out_port_from_the_pio_right(pio_racket_right),

              // the_pio_sw
               .in_port_to_the_pio_sw(pio_sw),

              // the_sram_16bit_512k_0
               .SRAM_ADDR_from_the_sram_16bit_512k_0(SRAM_ADDR),
               .SRAM_CE_N_from_the_sram_16bit_512k_0(SRAM_CE_N),
               .SRAM_DQ_to_and_from_the_sram_16bit_512k_0(SRAM_DQ),
               .SRAM_LB_N_from_the_sram_16bit_512k_0(SRAM_LB_N),
               .SRAM_OE_N_from_the_sram_16bit_512k_0(SRAM_OE_N),
               .SRAM_UB_N_from_the_sram_16bit_512k_0(SRAM_UB_N),
               .SRAM_WE_N_from_the_sram_16bit_512k_0(SRAM_WE_N)
            )
;




assign pio_sw={8'd0,y_coord,x_coord};
assign pio_key=new_coord;

lcd_spi_cotroller    u1	   (	
							// Host Side
							.iCLK(CLOCK_50),
							.iRST_n(DLY0),
							// 3 wire Side
							.o3WIRE_SCLK(ltm_sclk),
							.io3WIRE_SDAT(ltm_sda),
							.o3WIRE_SCEN(ltm_scen),
							.o3WIRE_BUSY_n(ltm_3wirebusy_n)
							);	
							
adc_spi_controller	u2		(
							.iCLK(CLOCK_50),
							.iRST_n(DLY0),
							.oADC_DIN(adc_din),
							.oADC_DCLK(adc_dclk),
							.oADC_CS(adc_cs),
							.iADC_DOUT(adc_dout),
							.iADC_BUSY(adc_busy),
							.iADC_PENIRQ_n(adc_penirq_n),
							.oX_COORD(x_coord),
							.oY_COORD(y_coord),
							.oNEW_COORD(new_coord),
							 );

touch_point_detector	u3	(
							.iCLK(CLOCK_50),
							.iRST_n(DLY0),
							.iX_COORD(x_coord),
							.iY_COORD(y_coord),
							.iNEW_COORD(new_coord),
							.iSDRAM_WRITE_EN(sdram_write_en),
							.oPHOTO_CNT(photo_cnt),
							);

flash_to_sdram_controller 	u4	   (
							.iPHOTO_NUM(2),
							.iRST_n(DLY1) ,
							.iF_CLK(F_CLK),
							.FL_DQ(FL_DQ)  ,				
							.oFL_ADDR(FL_ADDR) ,			
							.oFL_WE_N(FL_WE_N) ,				
							.oFL_RST_n(FL_RST_N),			
							.oFL_OE_N(FL_OE_N) ,				
							.oFL_CE_N(FL_CE_N) ,				
							.oSDRAM_WRITE_EN(sdram_write_en),
							.oSDRAM_WRITE(sdram_write),
							.oRED(sRED),
							.oGREEN(sGREEN),
							.oBLUE(sBLUE),
							);

SEG7_LUT_8 			u5		(	
							.oSEG0(HEX0),			
							.oSEG1(HEX1),	
							.oSEG2(HEX2),	
							.oSEG3(HEX3),	
							.oSEG4(HEX4),	
							.oSEG5(HEX5),	
							.oSEG6(HEX6),	
							.oSEG7(HEX7),	
							.iDIG({4'h0,x_coord,4'h0,y_coord}),
							.ON_OFF(8'b01110111) 
							);

lcd_timing_controller	u6  ( 
							.iCLK(ltm_nclk),
							.iRST_n(DLY2),
							// sdram side
							.iREAD_DATA1(Read_DATA1),
							.iREAD_DATA2(Read_DATA2),
							.oREAD_SDRAM_EN(mRead),
							// lcd side
							.oLCD_R(ltm_r),
							.oLCD_G(ltm_g),
							.oLCD_B(ltm_b), 
							.oHD(ltm_hd),
							.oVD(ltm_vd),
							.oDEN(ltm_den),
							
							
							.pio_racket_left(pio_racket_left),
                            .pio_racket_right(pio_racket_right),
                            .pio_pingpang(pio_pingpong),
                            .pio_hex(pio_hex)
							);
							
//	SDRAM frame buffer
Sdram_Control_4Port	u7	(	//	HOST Side
						    .REF_CLK(CLOCK_50),
							.RESET_N(1'b1),
							//	FIFO Write Side 1
						    .WR1_DATA({sRED,sGREEN}),
							.WR1(sdram_write),
							.WR1_FULL(WR1_FULL),
							.WR1_ADDR(0),
							.WR1_MAX_ADDR(800*480),		
							.WR1_LENGTH(9'h80),
							.WR1_LOAD(!DLY0),
							.WR1_CLK(F_CLK),
							//	FIFO Write Side 2
							
						    .WR2_DATA({8'h0,sBLUE}),
							.WR2(sdram_write),
							.WR2_ADDR(22'h100000),
							.WR2_MAX_ADDR(22'h100000+800*480),
							.WR2_LENGTH(9'h80),
							.WR2_LOAD(!DLY0),
							.WR2_CLK(F_CLK),
							
							//	FIFO Read Side 1
						    .RD1_DATA(Read_DATA1),
				        	.RD1(mRead),
				        	.RD1_ADDR(0),			
							.RD1_MAX_ADDR(800*480),
							.RD1_LENGTH(9'h80),
				        	.RD1_LOAD(!DLY0),
							.RD1_CLK(ltm_nclk),
							//	FIFO Read Side 2
						   
							.RD2_DATA(Read_DATA2),
				        	.RD2(mRead),
							.RD2_ADDR(22'h100000),			
							.RD2_MAX_ADDR(22'h100000+800*480),
							.RD2_LENGTH(9'h80),
				        	.RD2_LOAD(!DLY0),
							.RD2_CLK(ltm_nclk),
							
							//	SDRAM Side
						    .SA(DRAM_ADDR),
						    .BA({DRAM_BA_1,DRAM_BA_0}),
						    .CS_N(DRAM_CS_N),
						    .CKE(DRAM_CKE),
						    .RAS_N(DRAM_RAS_N),
				            .CAS_N(DRAM_CAS_N),
				            .WE_N(DRAM_WE_N),
						    .DQ(DRAM_DQ),
				            .DQM({DRAM_UDQM,DRAM_LDQM}),
							.SDR_CLK(DRAM_CLK),
							.CLK_33(ltm_nclk)
							);

Reset_Delay			u8	   (.iCLK(CLOCK_50),
							.iRST(KEY[0]),
							.oRST_0(DLY0),
							.oRST_1(DLY1),
							.oRST_2(DLY2)
							);


endmodule